/**
* \file: WaylandInputSourceImpl.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: M. Adachi / ADITJ/SW / madachi@jp.adit-jv.com
*
* \copyright (c) 2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef AAUTO_WAYLANDINPUTSORCEIMPL_H
#define AAUTO_WAYLANDINPUTSORCEIMPL_H

#include <aauto_macros.h>
#include <aauto/util/shared_ptr.h>
#include <aauto/InputSource.h>
#include <uspi/EndpointDataSharing.h>
#include "wayland/InputSourceReport.h"
#include "wayland/WaylandContext.h"
#include "wayland/WaylandSurface.h"
#include "wayland/TouchListener.h"
#include "wayland/PointerListener.h"
#include <uspi/ConfigHandle.h>
#include "aauto/AditInputSource.h"

namespace adit { namespace aauto {

class InputSourceConfig : public uspi::ConfigHandle
{
public:
bool ResultConfig()
{
    bool isValid = true;

    touchWidth      = getInt("touch-width", &isValid, Range(-1, INT_MAX));
    touchHeight     = getInt("touch-height", &isValid, Range(-1, INT_MAX));
    layerId         = getInt("wl-touch-layer-id", &isValid, Range(-1, INT_MAX));
    surfaceId       = getInt("wl-touch-surface-id", &isValid, Range(-1, INT_MAX));
    displayWidth    = getInt("display-width", &isValid, Range(-1, INT_MAX));
    displayHeight   = getInt("display-height", &isValid, Range(-1, INT_MAX));
    verbose         = getInt("enable-verbose-logging", &isValid, Range(0, 1), 0);
    triggerInterval = getInt("wl-touch-input-trigger-interval-usec", &isValid, Range(-1, INT_MAX));
    deviceType      = (WaylandDeviceType)getInt("wl-touch-type", &isValid,
                            Range(WaylandDeviceTypeFirst, WaylandDeviceTypeLast));
    shareWlDisplay  = getInt("wl-touch-share-surface", &isValid, Range(0, 1), 0);

    return isValid;
}
    int                 touchWidth;     // Width for GalReceiver
    int                 touchHeight;    // Hight for GalReceiver
    int                 layerId;        // Layer ID for layermanager
    int                 surfaceId;      // Surface ID for layermanager
    int                 displayWidth;   // Width for Touch Device
    int                 displayHeight;  // Hight for Touch Device
    int                 verbose;        // Flag for detail logdata
    int                 triggerInterval;// Interval time for touch event
    WaylandDeviceType   deviceType;     // Type of touch device
    bool                shareWlDisplay; // If true, wl_display shared by VideoSink endpoint
};

class WaylandInputSourceImpl : public IInputSourceCallbacks, public uspi::SharedDataReceiver
{
public:
    WaylandInputSourceImpl(InputSource* inInputSource, void* inSessionContext);
    ~WaylandInputSourceImpl();
    bool init();
    bool shutdown();
    void setConfigItem(string inKey, string inValue);
    void registerCallbacks(IAditInputSourceCallbacks* inCallbacks);

    InputSource* inputSource;

    // SharedDataReceiver implementation
    void onSurfaceDataProvided(wl_display* inWlDisplay);
    void onSurfaceDataExpired();
    void onResolutionDataProvided(int inWidth, int inHeight, int inMarginX, int inMarginY);

protected:
    // IInputSourceCallbacks
    void onInputFeedback(const InputFeedback& inFeedback);

private:
    bool touchInit(InputSourceConfig* inConfig, InputSource* inInputSource);
    void release();
    bool configErrorHandle();

    InputReport         inputReport;
    InputSourceConfig   config;
    IAditInputSourceCallbacks* mCallbacks;

    WaylandContext*     wayland;
    WaylandSurface*     surface;

    struct wl_display*  display;

    bool running;

    int mMarginX;
    int mMarginY;
};

} } /* namespace adit { namespace aauto { */

#endif /* AAUTO_WAYLANDINPUTSORCEIMPL_H */
